/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser;

import java.io.IOException;
import kdp.Log;
import kdp.classparser.ClassFile;
import kdp.classparser.FileReference;
import kdp.classparser.MethodInfo;

public class ClassParser {
    private String className;
    private String baseName;
    private int lineNumber = -1;
    public ClassFile classFile;
    private int classID;
    private byte typeTag;

    public ClassParser(String className, byte typeTag) {
        this.className = className;
        int index = className.lastIndexOf(47);
        this.baseName = index != -1 ? className.substring(index + 1) : className;
        this.typeTag = typeTag;
    }

    public boolean equals(String newclassName) {
        return this.className.equals(newclassName);
    }

    public String getBaseName() {
        return this.baseName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getClassFileName() {
        return this.className + ".class";
    }

    public String getFullClassFileName() {
        return this.className + ".class";
    }

    public ClassFile getClassFile() {
        return this.classFile;
    }

    public byte getJDWPTypeTag() {
        return this.typeTag;
    }

    public void setClassID(int classID) {
        this.classID = classID;
    }

    public int getClassID() {
        return this.classID;
    }

    public static void main(String[] args) {
        int lineNumber = 0;
        FileReference file = FileReference.create(args[0], args[1]);
        ClassFile classfile = new ClassFile(file, args[1], 76);
        try {
            classfile.readClassFile();
        }
        catch (IOException e) {
            Log.LOGN(3, "Main: caught IOException " + e);
        }
        Log.LOGN(3, "\n");
        if (args.length < 3) {
            classfile.print(System.out);
        } else {
            lineNumber = Integer.parseInt(args[2]);
            MethodInfo method = classfile.lookUpMethodByLineNumber(lineNumber);
            if (method != null) {
                Log.LOGN(3, "Associated the method \"" + method.getName() + "\" with line number " + lineNumber + ".");
                Log.LOGN(3, "The following information if available for " + method.getName() + ".");
                Log.LOGN(3, method.toString());
                Log.LOGN(3, "");
                Log.LOGN(3, "To put a breakpoint at line " + lineNumber + " break at code index " + method.getCodeIndex(lineNumber) + ".");
                Log.LOGN(3, "");
                Log.LOGN(3, "Breakpoints can be set at the following lines in " + method.getName() + ":");
                Log.LOGN(3, "tSource Line Number\tBytecode Offset");
                Log.LOGN(3, "t------------------\t---------------");
                int[][] lineNumbers = method.getBreakableLineNumbers();
                if (lineNumbers == null) {
                    Log.LOGN(3, "Method contains no breakable lines.");
                } else {
                    for (int lcv = 0; lcv < lineNumbers.length; ++lcv) {
                        Log.LOGN(3, "t\t" + lineNumbers[lcv][0] + "\t\t\t" + lineNumbers[lcv][1]);
                    }
                }
            } else {
                Log.LOGN(3, "Line number " + lineNumber + " does not contain" + " code within a method.");
            }
        }
    }
}

