/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser;

import java.io.DataInputStream;
import java.io.IOException;
import kdp.classparser.attributes.AttributeInfo;
import kdp.classparser.constantpoolclasses.ConstantPoolInfo;
import kdp.classparser.constantpoolclasses.ConstantUtf8Info;

public class FieldInfo {
    private static final int ACC_PUBLIC = 1;
    private static final int ACC_PRIVATE = 2;
    private static final int ACC_PROTECTED = 4;
    private static final int ACC_STATIC = 8;
    private static final int ACC_FINAL = 16;
    private static final int ACC_VOLATILE = 64;
    private static final int ACC_TRANSIENT = 128;
    private int accessFlags;
    private int nameIndex;
    private int descriptorIndex;
    private int attributesCount;
    private AttributeInfo[] attributes;
    private ConstantPoolInfo[] constantPool;

    public FieldInfo(DataInputStream iStream, ConstantPoolInfo[] constantPool) throws IOException {
        this.accessFlags = iStream.readUnsignedShort();
        this.nameIndex = iStream.readUnsignedShort();
        this.descriptorIndex = iStream.readUnsignedShort();
        this.attributesCount = iStream.readUnsignedShort();
        this.attributes = new AttributeInfo[this.attributesCount];
        for (int lcv = 0; lcv < this.attributesCount; ++lcv) {
            this.attributes[lcv] = new AttributeInfo(iStream, constantPool);
        }
        this.constantPool = constantPool;
    }

    public String getAccess() {
        String s = new String("");
        if ((this.accessFlags & 1) > 0) {
            s = s + "public ";
        }
        if ((this.accessFlags & 2) > 0) {
            s = s + "private ";
        }
        if ((this.accessFlags & 4) > 0) {
            s = s + "protected ";
        }
        if ((this.accessFlags & 8) > 0) {
            s = s + "static ";
        }
        if ((this.accessFlags & 0x10) > 0) {
            s = s + "final ";
        }
        if ((this.accessFlags & 0x40) > 0) {
            s = s + "volatile ";
        }
        if ((this.accessFlags & 0x80) > 0) {
            s = s + "transient";
        }
        if (s.length() == 0) {
            s = "Not explicitly specified.";
        }
        return s;
    }

    public String getType() {
        ConstantUtf8Info utf8Info = (ConstantUtf8Info)this.constantPool[this.descriptorIndex];
        return utf8Info.toString();
    }

    public String getName() {
        ConstantUtf8Info utf8Info = (ConstantUtf8Info)this.constantPool[this.nameIndex];
        return utf8Info.toString();
    }

    public String toString() {
        String s = new String("");
        s = s + "Field:\n\tAccess Flags=\t";
        s = s + this.getAccess();
        s = s + "\n\tName=\t\t" + this.getName();
        s = s + "\n\tClass=\t\t" + this.getType();
        for (int lcv = 0; lcv < this.attributesCount; ++lcv) {
            s = s + "\n\t" + this.attributes[lcv].toString();
        }
        return s;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }
}

