/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public abstract class FileReference {
    private FileReference() {
    }

    public static FileReference create(File file) {
        return new BaseFileReference(file);
    }

    public static FileReference create(JarFile jarFile, String element) {
        return new JarFileReference(jarFile, element);
    }

    public static FileReference create(String base, String filename) {
        File baseFile = new File(base);
        if (baseFile.isDirectory()) {
            return new BaseFileReference(new File(baseFile, filename));
        }
        try {
            return new JarFileReference(baseFile, filename);
        }
        catch (IOException e) {
            System.err.println("Couldn't open JAR file " + baseFile);
            return new NonExistentFileReference(baseFile + ":" + filename);
        }
    }

    public abstract InputStream getInputStream() throws IOException;

    public abstract String[] list(FilenameFilter var1);

    public abstract boolean exists();

    private static class JarManager {
        static Map jars = new TreeMap();

        private JarManager() {
        }

        static JarFile openJar(File file) throws IOException {
            JarFile jarFile = (JarFile)jars.get(file);
            if (jarFile == null) {
                jarFile = new JarFile(file);
                jars.put(file, jarFile);
            }
            return jarFile;
        }
    }

    private static class NonExistentFileReference
    extends FileReference {
        private String description;

        NonExistentFileReference(String description) {
            this.description = description;
        }

        public boolean exists() {
            return false;
        }

        public String toString() {
            return this.description;
        }

        public InputStream getInputStream() throws IOException {
            throw new FileNotFoundException(this.description);
        }

        public String[] list(FilenameFilter _) {
            return new String[0];
        }
    }

    private static class JarFileReference
    extends FileReference {
        private JarFile jarFile;
        private String element;

        JarFileReference(JarFile jarFile, String element) {
            this.jarFile = jarFile;
            this.element = element.replace(File.separatorChar, '/');
        }

        JarFileReference(File file, String element) throws IOException {
            this(JarManager.openJar(file), element);
        }

        public InputStream getInputStream() throws IOException {
            return this.jarFile.getInputStream(this.jarFile.getEntry(this.element));
        }

        public String toString() {
            return this.jarFile.getName() + ":" + this.element;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof JarFileReference)) {
                return false;
            }
            JarFileReference fr = (JarFileReference)o;
            return fr.jarFile.getName().equals(this.jarFile.getName()) && fr.element.equals(this.element);
        }

        public boolean exists() {
            return this.jarFile.getEntry(this.element) != null;
        }

        public String[] list(FilenameFilter filter) {
            ArrayList<String> files = new ArrayList<String>();
            Enumeration<JarEntry> e = this.jarFile.entries();
            while (e.hasMoreElements()) {
                int i;
                JarEntry je = e.nextElement();
                String name = je.getName();
                if (!name.startsWith(this.element)) continue;
                if ((name = name.substring(this.element.length())).startsWith("/")) {
                    name = name.substring(1);
                }
                if ((i = name.indexOf("/")) != -1) {
                    name = name.substring(0, i);
                }
                if (!filter.accept(new File(this.element), name)) continue;
                files.add(name);
            }
            return files.toArray(new String[files.size()]);
        }
    }

    private static class BaseFileReference
    extends FileReference {
        private File file;

        BaseFileReference(File file) {
            this.file = file;
        }

        public InputStream getInputStream() throws IOException {
            return new FileInputStream(this.file);
        }

        public String toString() {
            return this.file.toString();
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof BaseFileReference)) {
                return false;
            }
            BaseFileReference fr = (BaseFileReference)o;
            return fr.file.equals(this.file);
        }

        public boolean exists() {
            return this.file.exists();
        }

        public String[] list(FilenameFilter filter) {
            return this.file.list(filter);
        }
    }
}

