/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kdp.Log;
import kdp.classparser.StringParser;
import kdp.classparser.attributes.Attribute;
import kdp.classparser.attributes.AttributeInfo;
import kdp.classparser.attributes.CodeAttribute;
import kdp.classparser.attributes.LineNumberTableAttribute;
import kdp.classparser.attributes.LocalVariable;
import kdp.classparser.attributes.LocalVariableTable;
import kdp.classparser.attributes.LocalVariableTableAttribute;
import kdp.classparser.constantpoolclasses.ConstantPoolInfo;
import kdp.classparser.constantpoolclasses.ConstantUtf8Info;

public class MethodInfo {
    private static final int ACC_PUBLIC = 1;
    private static final int ACC_PRIVATE = 2;
    private static final int ACC_PROTECTED = 4;
    private static final int ACC_STATIC = 8;
    private static final int ACC_FINAL = 16;
    private static final int ACC_SYNCHRONIZED = 32;
    private static final int ACC_NATIVE = 256;
    private static final int ACC_ABSTRACT = 1024;
    private static final int ACC_STRICT = 2048;
    private int accessFlags;
    private int nameIndex;
    private int descriptorIndex;
    private int attributesCount;
    private AttributeInfo[] attributes;
    private ConstantPoolInfo[] constantPool;

    public MethodInfo(DataInputStream iStream, ConstantPoolInfo[] constantPool) throws IOException {
        this.accessFlags = iStream.readUnsignedShort();
        this.nameIndex = iStream.readUnsignedShort();
        this.descriptorIndex = iStream.readUnsignedShort();
        this.attributesCount = iStream.readUnsignedShort();
        this.attributes = new AttributeInfo[this.attributesCount];
        for (int lcv = 0; lcv < this.attributesCount; ++lcv) {
            this.attributes[lcv] = new AttributeInfo(iStream, constantPool);
        }
        this.constantPool = constantPool;
    }

    public int[][] getBreakableLineNumbers() {
        CodeAttribute code = this.getCodeAttribute();
        if (code == null) {
            Log.LOGN(2, "code is null!");
            return null;
        }
        LineNumberTableAttribute lines = code.getLineNumberTable();
        if (lines == null) {
            Log.LOGN(2, "lines is null!");
            return null;
        }
        return lines.getLineNumbersAndIndicesAsArray();
    }

    public CodeAttribute getCodeAttribute() {
        int attrIndex = 0;
        boolean found = false;
        while (!found && attrIndex < this.attributesCount) {
            if (this.attributes[attrIndex].getType() == 0) {
                found = true;
                continue;
            }
            ++attrIndex;
        }
        if (found) {
            AttributeInfo attrInfo = this.attributes[attrIndex];
            CodeAttribute code = (CodeAttribute)attrInfo.getInfo();
            return code;
        }
        return null;
    }

    public boolean containsLine(int lineNumber) {
        CodeAttribute code = this.getCodeAttribute();
        if (code != null) {
            return code.containsLine(lineNumber);
        }
        return false;
    }

    public int getCodeIndex(int lineNumber) {
        boolean found = false;
        boolean index = false;
        CodeAttribute code = this.getCodeAttribute();
        if (code == null) {
            return -1;
        }
        LineNumberTableAttribute lines = code.getLineNumberTable();
        if (lines == null) {
            return -1;
        }
        return lines.getCodeIndexBySourceLineNumber(lineNumber);
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public String getAccess() {
        String s = new String("");
        if ((this.accessFlags & 1) > 0) {
            s = s + "public ";
        }
        if ((this.accessFlags & 2) > 0) {
            s = s + "private ";
        }
        if ((this.accessFlags & 4) > 0) {
            s = s + "protected ";
        }
        if ((this.accessFlags & 8) > 0) {
            s = s + "static ";
        }
        if ((this.accessFlags & 0x10) > 0) {
            s = s + "final ";
        }
        if ((this.accessFlags & 0x20) > 0) {
            s = s + "synchronized ";
        }
        if ((this.accessFlags & 0x100) > 0) {
            s = s + "native ";
        }
        if ((this.accessFlags & 0x400) > 0) {
            s = s + "abstract ";
        }
        if ((this.accessFlags & 0x800) > 0) {
            s = s + "strict";
        }
        if (s.length() == 0) {
            s = "Not explicitly specified.";
        }
        return s;
    }

    public LinkedList getParameterList() {
        String s = new String("");
        ConstantUtf8Info utf8Info = (ConstantUtf8Info)this.constantPool[this.descriptorIndex];
        LinkedList paramList = StringParser.getParametersAsLL(utf8Info.toString());
        return paramList;
    }

    public String getReturnValue() {
        ConstantUtf8Info utf8Info = (ConstantUtf8Info)this.constantPool[this.descriptorIndex];
        return StringParser.getReturnValue(utf8Info.toString());
    }

    public String getName() {
        ConstantUtf8Info utf8Info = (ConstantUtf8Info)this.constantPool[this.nameIndex];
        String methodName = utf8Info.toString();
        return methodName;
    }

    public String getSignatureRaw() {
        ConstantUtf8Info utf8Info = (ConstantUtf8Info)this.constantPool[this.descriptorIndex];
        return utf8Info.toString();
    }

    public String getSignature() {
        ConstantUtf8Info utf8Info = (ConstantUtf8Info)this.constantPool[this.descriptorIndex];
        return StringParser.parseSignature(utf8Info.toString());
    }

    public String toString() {
        String s = new String("");
        s = s + "Method:\n\tAccess Flags=\t";
        s = s + this.getAccess();
        s = s + "\n\tName=\t\t";
        s = s + this.getName();
        s = s + "\n\tSignature=\t";
        s = s + this.getSignature();
        s = s + "\n\tRaw signature=\t";
        s = s + this.getSignatureRaw();
        for (int lcv = 0; lcv < this.attributesCount; ++lcv) {
            s = s + "\n\t" + this.attributes[lcv].toString();
        }
        s = s + "\n\t BreakableLines=\t";
        int[][] list = this.getBreakableLineNumbers();
        if (list == null) {
            s = s + "No breakable lines\n";
        } else {
            for (int i = 0; i < list.length; ++i) {
                s = s + "\tSourceLine: " + list[i][0] + " CodeIndex:  " + list[i][1] + "\n";
            }
        }
        return s;
    }

    public List getLocalVariables() {
        int i;
        AttributeInfo[] ai = null;
        int attribCount = 0;
        Attribute attribute = null;
        for (i = 0; i < this.attributesCount; ++i) {
            if (this.attributes[i].getType() != 0) continue;
            attribute = this.attributes[i].getInfo();
            ai = ((CodeAttribute)attribute).getAttributes();
            attribCount = ((CodeAttribute)attribute).getAttributeCount();
            break;
        }
        i = 0;
        for (i = 0; i < attribCount; ++i) {
            if (ai[i].getType() != 6) continue;
            attribute = ai[i].getInfo();
            LocalVariableTable[] localVariableTable = ((LocalVariableTableAttribute)attribute).getLocalVariableTable();
            ArrayList<LocalVariable> localVariableList = new ArrayList<LocalVariable>();
            for (i = 0; i < localVariableTable.length; ++i) {
                ConstantUtf8Info utf8Info = (ConstantUtf8Info)this.constantPool[localVariableTable[i].nameIndex];
                String name = utf8Info.toString();
                utf8Info = (ConstantUtf8Info)this.constantPool[localVariableTable[i].descriptorIndex];
                String type = StringParser.parseDataType(utf8Info.toString());
                localVariableList.add(new LocalVariable(name, type, localVariableTable[i].startPC, localVariableTable[i].length, localVariableTable[i].index));
            }
            return localVariableList;
        }
        return null;
    }

    public int getArgCount() {
        ConstantUtf8Info utf8Info = (ConstantUtf8Info)this.constantPool[this.descriptorIndex];
        int argCount = StringParser.getParameterCount(utf8Info.toString());
        return argCount + (this.is_static() ? 0 : 1);
    }

    public boolean is_static() {
        return (this.accessFlags & 8) != 0;
    }
}

