/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.TreeSet;
import kdp.Log;
import kdp.classparser.FileReference;

public class SearchPath {
    private String pathString;
    private String[] pathArray;

    public SearchPath(String searchPath) {
        StringTokenizer st = new StringTokenizer(searchPath, File.pathSeparator);
        ArrayList<String> dlist = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            dlist.add(st.nextToken());
        }
        this.pathString = searchPath;
        Log.LOGN(3, "!!!" + this.pathString);
        this.pathArray = dlist.toArray(new String[dlist.size()]);
        Log.LOGN(3, "Path array length is :" + this.pathArray.length);
        for (int i = 0; i < this.pathArray.length; ++i) {
            Log.LOGN(3, this.pathArray[i]);
        }
    }

    public boolean isEmpty() {
        return this.pathArray.length == 0;
    }

    public String asString() {
        return this.pathString;
    }

    public String[] asArray() {
        return (String[])this.pathArray.clone();
    }

    public int path_array_length() {
        return this.pathArray.length;
    }

    public FileReference resolve(String relativeFileName) {
        Log.LOGN(4, "relative filename = " + relativeFileName);
        Log.LOGN(4, "path array length in resolve is " + this.pathArray.length);
        if (!relativeFileName.endsWith(".class")) {
            relativeFileName = relativeFileName + ".class";
        }
        Log.LOGN(4, "relative filename now = " + relativeFileName);
        for (int i = 0; i < this.pathArray.length; ++i) {
            Log.LOGN(5, "pa=" + this.pathArray[i] + " " + "rfa=" + relativeFileName);
            FileReference path = FileReference.create(this.pathArray[i], relativeFileName);
            if (!path.exists()) continue;
            Log.LOGN(4, "  exists");
            return path;
        }
        return null;
    }

    public String[] children(String relativeDirName, FilenameFilter filter) {
        TreeSet<String> s = new TreeSet<String>();
        for (int i = 0; i < this.pathArray.length; ++i) {
            String[] childArray;
            FileReference path = FileReference.create(this.pathArray[i], relativeDirName);
            if (!path.exists() || (childArray = path.list(filter)) == null) continue;
            for (int j = 0; j < childArray.length; ++j) {
                if (s.contains(childArray[j])) continue;
                s.add(childArray[j]);
            }
        }
        return s.toArray(new String[s.size()]);
    }
}

