/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser;

import java.util.LinkedList;

public class StringParser {
    public static String parseSignature(String s) {
        String retVal = new String("");
        int timesThrough = 0;
        int index = s.lastIndexOf(41);
        String methodParams = new String(s.substring(1, index));
        retVal = retVal + "Params: ";
        if (methodParams.length() == 0) {
            retVal = retVal + "None";
        } else {
            while (methodParams.length() != 0) {
                String firstParam = StringParser.getFirstParam(methodParams);
                if (timesThrough > 0) {
                    retVal = retVal + ", ";
                }
                retVal = retVal + StringParser.parseDataType(firstParam);
                int length = methodParams.length();
                int firstParamLength = firstParam.length();
                methodParams = methodParams.substring(firstParamLength, length);
                ++timesThrough;
            }
        }
        int length = s.length();
        String methodReturnVal = new String(s.substring(index + 1, length));
        retVal = retVal + "\n\t\t\tReturn: " + StringParser.getReturnValue(methodReturnVal);
        return retVal;
    }

    public static String getReturnValue(String s) {
        int lastIndex = s.lastIndexOf(")");
        String returnValue = s.substring(lastIndex + 1);
        return StringParser.parseDataType(returnValue);
    }

    private static String getFirstParam(String s) {
        String retVal = new String("");
        switch (s.charAt(0)) {
            case 'V': {
                retVal = "V";
                break;
            }
            case 'B': {
                retVal = "B";
                break;
            }
            case 'C': {
                retVal = "C";
                break;
            }
            case 'D': {
                retVal = "D";
                break;
            }
            case 'F': {
                retVal = "F";
                break;
            }
            case 'I': {
                retVal = "I";
                break;
            }
            case 'J': {
                retVal = "J";
                break;
            }
            case 'L': {
                int index = s.indexOf(59);
                retVal = s.substring(0, index + 1);
                break;
            }
            case 'S': {
                retVal = "S";
                break;
            }
            case 'Z': {
                retVal = "Z";
                break;
            }
            case '[': {
                retVal = "[" + StringParser.getFirstParam(s.substring(1));
                break;
            }
            default: {
                retVal = s;
            }
        }
        return retVal;
    }

    public static String parseDataType(String s) {
        String retVal = new String("");
        switch (s.charAt(0)) {
            case 'V': {
                retVal = "void";
                break;
            }
            case 'B': {
                retVal = "byte";
                break;
            }
            case 'C': {
                retVal = "char";
                break;
            }
            case 'D': {
                retVal = "double";
                break;
            }
            case 'F': {
                retVal = "float";
                break;
            }
            case 'I': {
                retVal = "int";
                break;
            }
            case 'J': {
                retVal = "long";
                break;
            }
            case 'L': {
                retVal = StringParser.parseClassNameRemoveFirst(s);
                break;
            }
            case 'S': {
                retVal = "short";
                break;
            }
            case 'Z': {
                retVal = "boolean";
                break;
            }
            case '[': {
                retVal = StringParser.parseDataType(s.substring(1, s.length())) + "[]";
                break;
            }
            default: {
                retVal = s;
            }
        }
        return retVal;
    }

    public static LinkedList getParametersAsLL(String s) {
        LinkedList<String> paramList = new LinkedList<String>();
        int index = s.lastIndexOf(41);
        String methodParams = new String(s.substring(1, index));
        if (methodParams.length() == 0) {
            return null;
        }
        while (methodParams.length() != 0) {
            String firstParam = StringParser.getFirstParam(methodParams);
            paramList.add(StringParser.parseDataType(firstParam));
            int length = methodParams.length();
            int firstParamLength = firstParam.length();
            methodParams = methodParams.substring(firstParamLength, length);
        }
        return paramList;
    }

    public static int getParameterCount(String s) {
        int index = s.lastIndexOf(41);
        int wordCount = 0;
        String methodParams = new String(s.substring(1, index));
        if (methodParams.length() == 0) {
            return 0;
        }
        while (methodParams.length() != 0) {
            String firstParam = StringParser.getFirstParam(methodParams);
            switch (firstParam.charAt(0)) {
                case 'V': {
                    break;
                }
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'L': 
                case 'S': 
                case 'Z': 
                case '[': {
                    ++wordCount;
                    break;
                }
                case 'D': 
                case 'J': {
                    wordCount += 2;
                    break;
                }
                default: {
                    return 0;
                }
            }
            int length = methodParams.length();
            int firstParamLength = firstParam.length();
            methodParams = methodParams.substring(firstParamLength, length);
        }
        return wordCount;
    }

    public static String parseClassName(String s) {
        String retVal = new String(s);
        retVal = retVal.replace('/', '.');
        return retVal;
    }

    private static String parseClassNameRemoveFirst(String s) {
        String retVal = new String(s);
        retVal = retVal.substring(1);
        retVal = retVal.replace('/', '.');
        retVal = retVal.replace(';', ' ');
        retVal = retVal.trim();
        return retVal;
    }
}

