/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser.attributes;

import java.io.DataInputStream;
import java.io.IOException;
import kdp.classparser.attributes.Attribute;
import kdp.classparser.attributes.AttributeInfo;
import kdp.classparser.attributes.ExceptionTable;
import kdp.classparser.attributes.LineNumberTableAttribute;
import kdp.classparser.constantpoolclasses.ConstantPoolInfo;
import kdp.classparser.constantpoolclasses.ConstantUtf8Info;

public class CodeAttribute
extends Attribute {
    private int attributeNameIndex;
    private int attributeLength;
    private int maxStack;
    private int maxLocals;
    private int codeLength;
    private byte[] code;
    private int exceptionTableLength;
    private ExceptionTable[] exceptionTable;
    private int attributesCount;
    private AttributeInfo[] attributes;

    public CodeAttribute(DataInputStream iStream, ConstantPoolInfo[] constantPool, int attributeNameIndex, int attributeLength) throws IOException {
        int lcv;
        this.attributeNameIndex = attributeNameIndex;
        this.attributeLength = attributeLength;
        this.maxStack = iStream.readUnsignedShort();
        this.maxLocals = iStream.readUnsignedShort();
        this.codeLength = iStream.readInt();
        this.code = new byte[this.codeLength];
        for (lcv = 0; lcv < this.codeLength; ++lcv) {
            this.code[lcv] = iStream.readByte();
        }
        this.exceptionTableLength = iStream.readUnsignedShort();
        this.exceptionTable = new ExceptionTable[this.exceptionTableLength];
        for (lcv = 0; lcv < this.exceptionTableLength; ++lcv) {
            this.exceptionTable[lcv] = new ExceptionTable(iStream);
        }
        this.attributesCount = iStream.readUnsignedShort();
        this.attributes = new AttributeInfo[this.attributesCount];
        for (lcv = 0; lcv < this.attributesCount; ++lcv) {
            this.attributes[lcv] = new AttributeInfo(iStream, constantPool);
        }
    }

    public LineNumberTableAttribute getLineNumberTable() {
        int attrIndex = 0;
        boolean found = false;
        while (!found && attrIndex < this.attributesCount) {
            if (this.attributes[attrIndex].getType() == 5) {
                found = true;
                continue;
            }
            ++attrIndex;
        }
        if (found) {
            AttributeInfo attrInfo = this.attributes[attrIndex];
            LineNumberTableAttribute lineNumberTable = (LineNumberTableAttribute)attrInfo.getInfo();
            return lineNumberTable;
        }
        return null;
    }

    public boolean containsLine(int lineNumber) {
        LineNumberTableAttribute lines = this.getLineNumberTable();
        if (lines != null) {
            return lines.containsLine(lineNumber);
        }
        return false;
    }

    public byte[] getByteCodes() {
        byte[] ret = new byte[this.code.length];
        System.arraycopy(this.code, 0, ret, 0, this.code.length);
        return ret;
    }

    public String toString(ConstantPoolInfo[] constantPool) {
        String s = new String("");
        ConstantUtf8Info utf8Info = (ConstantUtf8Info)constantPool[this.attributeNameIndex];
        s = s + utf8Info.toString();
        for (int lcv = 0; lcv < this.attributesCount; ++lcv) {
            s = s + "\n\t\t" + this.attributes[lcv].toString();
        }
        return s;
    }

    public AttributeInfo[] getAttributes() {
        return this.attributes;
    }

    public int getCodeLength() {
        return this.codeLength;
    }

    public int getAttributeCount() {
        return this.attributesCount;
    }
}

