/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser.attributes;

import java.io.DataInputStream;
import java.io.IOException;
import kdp.classparser.attributes.Attribute;
import kdp.classparser.constantpoolclasses.ConstantDoubleInfo;
import kdp.classparser.constantpoolclasses.ConstantFloatInfo;
import kdp.classparser.constantpoolclasses.ConstantIntegerInfo;
import kdp.classparser.constantpoolclasses.ConstantLongInfo;
import kdp.classparser.constantpoolclasses.ConstantPoolInfo;
import kdp.classparser.constantpoolclasses.ConstantStringInfo;
import kdp.classparser.constantpoolclasses.ConstantUtf8Info;

public class ConstantValueAttribute
extends Attribute {
    private int attributeNameIndex;
    private int attributeLength;
    private int constantValueIndex;

    public ConstantValueAttribute(DataInputStream iStream, int attributeNameIndex, int attributeLength) throws IOException {
        this.attributeNameIndex = attributeNameIndex;
        this.attributeLength = attributeLength;
        this.constantValueIndex = iStream.readUnsignedShort();
    }

    public String toString(ConstantPoolInfo[] constantPool) {
        String s = new String("");
        ConstantUtf8Info utf8Info = (ConstantUtf8Info)constantPool[this.attributeNameIndex];
        s = s + utf8Info.toString() + "\n\t\t\t";
        ConstantPoolInfo cpInfo = constantPool[this.constantValueIndex];
        switch (cpInfo.getTag()) {
            case 5: {
                ConstantLongInfo cpInfo2 = (ConstantLongInfo)cpInfo;
                s = s + cpInfo2.toString();
                break;
            }
            case 4: {
                ConstantFloatInfo cpInfo2 = (ConstantFloatInfo)cpInfo;
                s = s + cpInfo2.toString();
                break;
            }
            case 6: {
                ConstantDoubleInfo cpInfo2 = (ConstantDoubleInfo)cpInfo;
                s = s + cpInfo2.toString();
                break;
            }
            case 3: {
                ConstantIntegerInfo cpInfo2 = (ConstantIntegerInfo)cpInfo;
                s = s + cpInfo2.toString();
                break;
            }
            case 8: {
                ConstantStringInfo cpInfo2 = (ConstantStringInfo)cpInfo;
                s = s + cpInfo2.toString(constantPool);
                break;
            }
        }
        return s;
    }
}

