/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser.attributes;

import java.io.DataInputStream;
import java.io.IOException;
import kdp.classparser.StringParser;
import kdp.classparser.attributes.Attribute;
import kdp.classparser.constantpoolclasses.ConstantClassInfo;
import kdp.classparser.constantpoolclasses.ConstantPoolInfo;
import kdp.classparser.constantpoolclasses.ConstantUtf8Info;

public class ExceptionsAttribute
extends Attribute {
    private int attributeNameIndex;
    private int attributeLength;
    private int numberOfExceptions;
    private int[] exceptionIndexTable;

    public ExceptionsAttribute(DataInputStream iStream, int attributeNameIndex, int attributeLength) throws IOException {
        this.attributeNameIndex = attributeNameIndex;
        this.attributeLength = attributeLength;
        this.numberOfExceptions = iStream.readUnsignedShort();
        this.exceptionIndexTable = new int[this.numberOfExceptions];
        for (int lcv = 0; lcv < this.numberOfExceptions; ++lcv) {
            this.exceptionIndexTable[lcv] = iStream.readUnsignedShort();
        }
    }

    public String toString(ConstantPoolInfo[] constantPool) {
        String s = new String("");
        ConstantUtf8Info utf8Info = (ConstantUtf8Info)constantPool[this.attributeNameIndex];
        s = s + utf8Info.toString();
        for (int lcv = 0; lcv < this.numberOfExceptions; ++lcv) {
            int index = this.exceptionIndexTable[lcv];
            ConstantClassInfo c = (ConstantClassInfo)constantPool[index];
            utf8Info = (ConstantUtf8Info)constantPool[c.getNameIndex()];
            s = s + "\n\t\t\tThrows\t";
            s = s + StringParser.parseClassName(utf8Info.toString());
        }
        return s;
    }
}

