/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser.attributes;

import java.io.DataInputStream;
import java.io.IOException;
import kdp.classparser.attributes.Attribute;
import kdp.classparser.attributes.InnerClassesTable;
import kdp.classparser.constantpoolclasses.ConstantPoolInfo;
import kdp.classparser.constantpoolclasses.ConstantUtf8Info;

public class InnerClassesAttribute
extends Attribute {
    private int attributeNameIndex;
    private int attributeLength;
    private int numberOfClasses;
    private InnerClassesTable[] classes;

    public InnerClassesAttribute(DataInputStream iStream, int attributeNameIndex, int attributeLength) throws IOException {
        this.attributeNameIndex = attributeNameIndex;
        this.attributeLength = attributeLength;
        this.numberOfClasses = iStream.readUnsignedShort();
        this.classes = new InnerClassesTable[this.numberOfClasses];
        for (int lcv = 0; lcv < this.numberOfClasses; ++lcv) {
            this.classes[lcv] = new InnerClassesTable(iStream);
        }
    }

    public String toString(ConstantPoolInfo[] constantPool) {
        String s = new String("");
        ConstantUtf8Info utf8Info = (ConstantUtf8Info)constantPool[this.attributeNameIndex];
        s = s + "\t" + utf8Info.toString() + "\tNot Done";
        for (int lcv = 0; lcv < this.numberOfClasses; ++lcv) {
            s = s + "\n\t\t\t" + this.classes[lcv];
        }
        return s;
    }
}

