/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser.attributes;

import java.io.DataInputStream;
import java.io.IOException;

public class InnerClassesTable {
    private static final int ACC_PUBLIC = 1;
    private static final int ACC_PRIVATE = 2;
    private static final int ACC_PROTECTED = 4;
    private static final int ACC_STATIC = 8;
    private static final int ACC_FINAL = 16;
    private static final int ACC_INTERFACE = 512;
    private static final int ACC_ABSTRACT = 1024;
    private int innerClassInfoIndex;
    private int outerClassInfoIndex;
    private int innerNameIndex;
    private int innerClassAccessFlags;

    public InnerClassesTable(DataInputStream iStream) throws IOException {
        this.innerClassInfoIndex = iStream.readUnsignedShort();
        this.outerClassInfoIndex = iStream.readUnsignedShort();
        this.innerNameIndex = iStream.readUnsignedShort();
        this.innerClassAccessFlags = iStream.readUnsignedShort();
    }

    public String toString() {
        String s = new String("");
        s = s + "\n\tinnerClassInfoIndex=" + this.innerClassInfoIndex;
        s = s + "\n\touterClassInfoIndex=" + this.outerClassInfoIndex;
        s = s + "\n\tinnerNameIndex=" + this.innerNameIndex;
        s = s + "\n\tinnerClassAccessFlags=";
        if ((this.innerClassAccessFlags & 1) > 0) {
            s = s + "public ";
        }
        if ((this.innerClassAccessFlags & 2) > 0) {
            s = s + "private ";
        }
        if ((this.innerClassAccessFlags & 4) > 0) {
            s = s + "protected ";
        }
        if ((this.innerClassAccessFlags & 8) > 0) {
            s = s + "static ";
        }
        if ((this.innerClassAccessFlags & 0x10) > 0) {
            s = s + "final ";
        }
        if ((this.innerClassAccessFlags & 0x200) > 0) {
            s = s + "interface ";
        }
        if ((this.innerClassAccessFlags & 0x400) > 0) {
            s = s + "abstract";
        }
        return s;
    }
}

