/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser.attributes;

import java.io.DataInputStream;
import java.io.IOException;
import kdp.Log;
import kdp.classparser.attributes.Attribute;
import kdp.classparser.attributes.LineNumberTable;
import kdp.classparser.constantpoolclasses.ConstantPoolInfo;
import kdp.classparser.constantpoolclasses.ConstantUtf8Info;

public class LineNumberTableAttribute
extends Attribute {
    private int attributeNameIndex;
    private int attributeLength;
    private int lineNumberTableLength;
    private LineNumberTable[] lineNumberTable;

    public LineNumberTableAttribute(DataInputStream iStream, int attributeNameIndex, int attributeLength) throws IOException {
        this.attributeNameIndex = attributeNameIndex;
        this.attributeLength = attributeLength;
        this.lineNumberTableLength = iStream.readUnsignedShort();
        this.lineNumberTable = new LineNumberTable[this.lineNumberTableLength];
        for (int lcv = 0; lcv < this.lineNumberTableLength; ++lcv) {
            this.lineNumberTable[lcv] = new LineNumberTable();
            this.lineNumberTable[lcv].startPC = iStream.readUnsignedShort();
            this.lineNumberTable[lcv].lineNumber = iStream.readUnsignedShort();
        }
    }

    public int[][] getLineNumbersAndIndicesAsArray() {
        int[][] lineArray = new int[this.lineNumberTableLength][2];
        for (int lcv = 0; lcv < this.lineNumberTableLength; ++lcv) {
            lineArray[lcv][0] = this.lineNumberTable[lcv].startPC;
            lineArray[lcv][1] = this.lineNumberTable[lcv].lineNumber;
        }
        return lineArray;
    }

    public int getCodeIndexBySourceLineNumber(int lineNumber) {
        boolean found = false;
        int index = 0;
        while (!found && index < this.lineNumberTableLength) {
            if (lineNumber == this.lineNumberTable[index].lineNumber) {
                found = true;
                continue;
            }
            ++index;
        }
        if (found) {
            return this.lineNumberTable[index].startPC;
        }
        return -1;
    }

    public boolean containsLine(int lineNumber) {
        boolean found = false;
        int index = 0;
        while (!found && index < this.lineNumberTableLength) {
            if (lineNumber == this.lineNumberTable[index].lineNumber) {
                found = true;
                continue;
            }
            ++index;
        }
        return found;
    }

    private int getIndexThatContainsOpcode(long offset) {
        for (int i = 0; i < this.lineNumberTableLength - 1; ++i) {
            if (offset < (long)this.lineNumberTable[i].startPC || offset >= (long)this.lineNumberTable[i + 1].startPC) continue;
            return i;
        }
        if (offset >= (long)this.lineNumberTable[this.lineNumberTableLength - 1].startPC) {
            return this.lineNumberTableLength - 1;
        }
        return -1;
    }

    public int getDupCurrentExecutableLineCodeIndex(long offset) {
        int firstIndex = this.getNextExecutableLineCodeIndex(offset, false);
        if (firstIndex == -1) {
            return -1;
        }
        return this.getOtherLineIndex(--firstIndex);
    }

    public long getOffsetofDupNextLine(int index) {
        if (index == -1 || index == this.lineNumberTableLength - 1) {
            return -1L;
        }
        return this.lineNumberTable[index + 1].startPC;
    }

    private int getOtherLineIndex(int index) {
        for (int i = 0; i < this.lineNumberTableLength; ++i) {
            if (i == index || this.lineNumberTable[i].lineNumber != this.lineNumberTable[index].lineNumber) continue;
            return i;
        }
        return -1;
    }

    public int getCurrentLineCodeIndex(long offset) {
        int currentIndex = this.getIndexThatContainsOpcode(offset);
        Log.LOGN(3, "getCurrent: index=" + currentIndex);
        return currentIndex;
    }

    public int getNextExecutableLineCodeIndex(long offset) {
        return this.getNextExecutableLineCodeIndex(offset, true);
    }

    private int getNextExecutableLineCodeIndex(long offset, boolean logging) {
        int otherIndex;
        int firstIndex = this.getIndexThatContainsOpcode(offset);
        if (logging) {
            Log.LOGN(3, "getNext: firstIndex=" + firstIndex);
        }
        if ((otherIndex = this.getOtherLineIndex(firstIndex)) != -1) {
            if (logging) {
                Log.LOGN(3, "getNext: otherIndex=" + otherIndex);
            }
            if (otherIndex < firstIndex) {
                if (logging) {
                    Log.LOGN(3, "getNext: otherIndex < firstIndex");
                }
                return otherIndex + 1;
            }
            if (logging) {
                Log.LOGN(3, "getNext: otherIndex > firstIndex");
            }
            return firstIndex + 1;
        }
        if (firstIndex + 1 < this.lineNumberTableLength) {
            return firstIndex + 1;
        }
        return -1;
    }

    public long getStartPCFromIndex(int index) {
        if (index == -1) {
            return -1L;
        }
        return this.lineNumberTable[index].startPC;
    }

    public int getLineNumberFromIndex(int index) {
        if (index == -1 || index >= this.lineNumberTableLength) {
            return -1;
        }
        return this.lineNumberTable[index].lineNumber;
    }

    public String toString(ConstantPoolInfo[] constantPool) {
        String s = new String("");
        ConstantUtf8Info utf8Info = (ConstantUtf8Info)constantPool[this.attributeNameIndex];
        s = s + "\t" + utf8Info.toString();
        return s;
    }
}

