/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser.attributes;

import java.io.DataInputStream;
import java.io.IOException;
import kdp.classparser.StringParser;
import kdp.classparser.attributes.Attribute;
import kdp.classparser.attributes.LocalVariableTable;
import kdp.classparser.constantpoolclasses.ConstantPoolInfo;
import kdp.classparser.constantpoolclasses.ConstantUtf8Info;

public class LocalVariableTableAttribute
extends Attribute {
    private int attributeNameIndex;
    private int attributeLength;
    private int localVariableTableLength;
    private LocalVariableTable[] localVariableTable;

    public LocalVariableTableAttribute(DataInputStream iStream, int attributeNameIndex, int attributeLength) throws IOException {
        this.attributeNameIndex = attributeNameIndex;
        this.attributeLength = attributeLength;
        this.localVariableTableLength = iStream.readUnsignedShort();
        this.localVariableTable = new LocalVariableTable[this.localVariableTableLength];
        for (int lcv = 0; lcv < this.localVariableTableLength; ++lcv) {
            this.localVariableTable[lcv] = new LocalVariableTable();
            this.localVariableTable[lcv].startPC = iStream.readUnsignedShort();
            this.localVariableTable[lcv].length = iStream.readUnsignedShort();
            this.localVariableTable[lcv].nameIndex = iStream.readUnsignedShort();
            this.localVariableTable[lcv].descriptorIndex = iStream.readUnsignedShort();
            this.localVariableTable[lcv].index = iStream.readUnsignedShort();
        }
    }

    public String toString(ConstantPoolInfo[] constantPool) {
        String s = new String("");
        ConstantUtf8Info utf8Info = (ConstantUtf8Info)constantPool[this.attributeNameIndex];
        s = s + "\t" + utf8Info.toString();
        for (int lcv = 0; lcv < this.localVariableTableLength; ++lcv) {
            utf8Info = (ConstantUtf8Info)constantPool[this.localVariableTable[lcv].nameIndex];
            s = s + "\n\t\t\t\tName =\t" + utf8Info.toString();
            utf8Info = (ConstantUtf8Info)constantPool[this.localVariableTable[lcv].descriptorIndex];
            s = s + "\n\t\t\t\tClass=\t" + StringParser.parseDataType(utf8Info.toString());
        }
        return s;
    }

    public LocalVariableTable[] getLocalVariableTable() {
        return this.localVariableTable;
    }
}

