/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser.constantpoolclasses;

import java.io.DataInputStream;
import java.io.IOException;
import kdp.classparser.constantpoolclasses.ConstantPoolInfo;

public class ConstantDoubleInfo
extends ConstantPoolInfo {
    private int highBytes;
    private int lowBytes;

    public ConstantDoubleInfo(DataInputStream iStream) throws IOException {
        this.tag = (byte)6;
        this.highBytes = iStream.readInt();
        this.lowBytes = iStream.readInt();
    }

    public String toString() {
        long longValue = ((long)this.highBytes << 32) + (long)this.lowBytes;
        if (longValue == 0x7FF0000000000000L) {
            return "CONSTANT_Double=\tPositive Infinity";
        }
        if (longValue == -4503599627370496L) {
            return "CONSTANT_Double=\tNegative Infinity";
        }
        if (longValue >= 9218868437227405313L && longValue <= Long.MAX_VALUE || longValue >= -4503599627370495L && longValue <= -1L) {
            return "CONSTANT_Double=\tNaN";
        }
        int s = longValue >> 63 == 0L ? 1 : -1;
        int e = (int)(longValue >> 52 & 0x7FFL);
        long m = e == 0 ? (longValue & 0xFFFFFFFFFFFFFL) << 1 : longValue & 0xFFFFFFFFFFFFFL | 0x10000000000000L;
        double value = (long)s * m * (long)(2 ^ e - 1075);
        return "CONSTANT_Double=\t" + value;
    }
}

