/*
 * Decompiled with CFR 0.152.
 */
package kdp.classparser.constantpoolclasses;

import java.io.DataInputStream;
import java.io.IOException;
import kdp.classparser.constantpoolclasses.ConstantPoolInfo;

public class ConstantFloatInfo
extends ConstantPoolInfo {
    private int bytes;

    public ConstantFloatInfo(DataInputStream iStream) throws IOException {
        this.tag = (byte)4;
        this.bytes = iStream.readInt();
    }

    public String toString() {
        if (this.bytes == 2139095040) {
            return "CONSTANT_Float=\tPositive Infinity";
        }
        if (this.bytes == -8388608) {
            return "CONSTANT_Float=\tNegative Infinity";
        }
        if (this.bytes >= 2139095041 && this.bytes <= Integer.MAX_VALUE || this.bytes >= -8388607 && this.bytes <= -1) {
            return "CONSTANT_Float=\tNaN";
        }
        int s = this.bytes >> 31 == 0 ? 1 : -1;
        int e = this.bytes >> 23 & 0xFF;
        int m = e == 0 ? (this.bytes & 0x7FFFFF) << 1 : this.bytes & 0x7FFFFF | 0x800000;
        float value = s * m * (2 ^ e - 150);
        return "CONSTANT_Float=\t" + value;
    }
}

