/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.ueiproxy;

import com.sun.jme.toolkit.device.cdcappmanager.api.CdcAppEventListener;
import com.sun.jme.toolkit.device.cdcappmanager.api.CdcAppManager;
import com.sun.jme.toolkit.ueiproxy.DeviceController;
import com.sun.jme.toolkit.ueiproxy.DeviceControllerListener;
import com.sun.jme.toolkit.ueiproxy.Task;
import com.sun.jme.toolkit.ueiproxy.UeiProxyException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

public final class CdcRunningAppTask
extends Task
implements CdcAppEventListener,
DeviceControllerListener {
    private static final Logger LOGGER = Logger.getLogger(CdcRunningAppTask.class);
    private final CdcAppManager applicationManager;
    private boolean unknownApplicationId;
    private boolean finished;
    private List<String> tmpStoppedAppIds;

    public CdcRunningAppTask(DeviceController deviceController, CdcAppManager cdcAppManager) throws UeiProxyException {
        this.deviceController = deviceController;
        this.applicationManager = cdcAppManager;
        this.unknownApplicationId = true;
        this.tmpStoppedAppIds = new ArrayList<String>(0);
        deviceController.registerCallback("CdcAppManager", CdcAppEventListener.class, this, "addCdcAppEventListener", "removeCdcAppEventListener");
        deviceController.addListener(this);
        deviceController.showDeviceOutput();
    }

    @Override
    public void stop() {
        this.finishAndNotify();
    }

    @Override
    public synchronized boolean isFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setApplicationId(int n) {
        boolean bl;
        CdcRunningAppTask cdcRunningAppTask = this;
        synchronized (cdcRunningAppTask) {
            bl = this.tmpStoppedAppIds.contains(Integer.toString(n));
            this.tmpStoppedAppIds = null;
            this.applicationId = n;
            this.unknownApplicationId = false;
        }
        if (bl) {
            this.finishAndNotify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleCdcAppEvent(String string) {
        boolean bl = false;
        CdcRunningAppTask cdcRunningAppTask = this;
        synchronized (cdcRunningAppTask) {
            if (this.unknownApplicationId) {
                this.tmpStoppedAppIds.add(string);
            } else if (string.equals(Integer.toString(this.applicationId))) {
                bl = true;
            }
        }
        if (bl) {
            this.finishAndNotify();
        }
    }

    @Override
    public void deviceDisconnected(DeviceController deviceController) {
        this.finishAndNotify();
    }

    @Override
    public void controllerStopped(DeviceController deviceController) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishAndNotify() {
        boolean bl;
        CdcRunningAppTask cdcRunningAppTask = this;
        synchronized (cdcRunningAppTask) {
            bl = this.finished;
            this.finished = true;
        }
        if (!bl) {
            this.deviceController.hideDeviceOutput();
            this.deviceController.unregisterCallback("CdcAppManager", this);
            this.deviceController.removeListener(this);
            this.notifyFinished();
        }
    }
}

