/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.ueiproxy;

import com.sun.jme.toolkit.device.connection.api.Connection;
import com.sun.jme.toolkit.device.debugging.api.Debugging;
import com.sun.jme.toolkit.device.outputredirect.api.OutputRedirection;
import com.sun.jme.toolkit.remoting.client.api.ObjectServerConnection;
import com.sun.jme.toolkit.remoting.client.api.ObjectServerConnectionListener;
import com.sun.jme.toolkit.ueiproxy.DeviceControllerException;
import com.sun.jme.toolkit.ueiproxy.DeviceControllerListener;
import com.sun.jme.toolkit.ueiproxy.DeviceOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public final class DeviceController
implements ObjectServerConnectionListener {
    private static final Logger LOGGER = Logger.getLogger(DeviceController.class);
    private final int deviceId;
    private final ObjectServerConnection devObjServerConnection;
    private final DeviceOutput stdoutDeviceOutput;
    private final DeviceOutput stderrDeviceOutput;
    private final Set<DeviceControllerListener> listeners = new HashSet<DeviceControllerListener>();
    private int showOutputCounter;
    private boolean deviceDisconnected;
    private boolean stopped;

    protected DeviceController(int n, ObjectServerConnection objectServerConnection) {
        this.deviceId = n;
        this.devObjServerConnection = objectServerConnection;
        DeviceOutput deviceOutput = null;
        DeviceOutput deviceOutput2 = null;
        try {
            OutputRedirection outputRedirection = this.getObjectFromDevice(OutputRedirection.class, "OutputRedirection");
            deviceOutput = DeviceController.constructDeviceOutput(outputRedirection.getStdoutPortNumber(), System.out);
            deviceOutput2 = DeviceController.constructDeviceOutput(outputRedirection.getStderrPortNumber(), System.err);
        }
        catch (Exception exception) {
            LOGGER.error((Object)("Failed to redirect output from device " + n), (Throwable)exception);
        }
        this.stdoutDeviceOutput = deviceOutput;
        this.stderrDeviceOutput = deviceOutput2;
        objectServerConnection.addConnectionListener((ObjectServerConnectionListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void stop() {
        DeviceControllerListener[] deviceControllerListenerArray = null;
        DeviceControllerListener[] deviceControllerListenerArray2 = this;
        synchronized (this) {
            if (!this.stopped) {
                this.devObjServerConnection.removeConnectionListener((ObjectServerConnectionListener)this);
                deviceControllerListenerArray = this.getCurrentListeners();
                this.stopped = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (deviceControllerListenerArray != null) {
                for (DeviceControllerListener deviceControllerListener : deviceControllerListenerArray) {
                    deviceControllerListener.controllerStopped((DeviceController)this);
                }
            }
            if (!LOGGER.isDebugEnabled()) return;
            deviceControllerListenerArray2 = this;
            synchronized (this) {
                if (this.showOutputCounter == 0) return;
                LOGGER.debug((Object)("Show output counter din't reach 0 for device " + this.deviceId + " (showOutputCounter = " + this.showOutputCounter + ")"));
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }

    public int getDeviceId() {
        return this.deviceId;
    }

    public InetAddress getDeviceHostAddress() throws DeviceControllerException {
        Connection connection = this.getObjectFromDevice(Connection.class, "Connection");
        try {
            return connection.getDeviceHostAddress();
        }
        catch (Exception exception) {
            throw new DeviceControllerException(this.deviceId, "Failed to get device host address for device %DEVICE_ID%!", exception);
        }
    }

    public int getJdwpPortNumber() throws DeviceControllerException {
        Debugging debugging = this.getObjectFromDevice(Debugging.class, "Debugging");
        try {
            return debugging.getJdwpPortNumber();
        }
        catch (Exception exception) {
            throw new DeviceControllerException(this.deviceId, "Failed to get device JDWP port number for device %DEVICE_ID%!", exception);
        }
    }

    public synchronized boolean isDeviceDisconnected() {
        return this.deviceDisconnected;
    }

    public synchronized boolean isStopped() {
        return this.stopped;
    }

    public synchronized void addListener(DeviceControllerListener deviceControllerListener) {
        this.listeners.add(deviceControllerListener);
    }

    public synchronized void removeListener(DeviceControllerListener deviceControllerListener) {
        this.listeners.remove(deviceControllerListener);
    }

    public synchronized void showDeviceOutput() {
        if (this.showOutputCounter == 0) {
            this.showDeviceOutput(this.stdoutDeviceOutput, "stdout");
            this.showDeviceOutput(this.stderrDeviceOutput, "stderr");
        }
        ++this.showOutputCounter;
    }

    public synchronized void hideDeviceOutput() {
        if (--this.showOutputCounter == 0) {
            this.hideDeviceOutput(this.stdoutDeviceOutput, "stdout");
            this.hideDeviceOutput(this.stderrDeviceOutput, "stderr");
        }
    }

    public <T> T getObjectFromDevice(Class<T> clazz, String string) throws DeviceControllerException {
        Object object;
        try {
            object = this.devObjServerConnection.findObject(clazz, string);
            LOGGER.debug((Object)("Got reference to \"" + string + "\" from device " + this.deviceId));
        }
        catch (Exception exception) {
            throw new DeviceControllerException(this.deviceId, "Can't get reference to \"" + string + "\" from" + " device %DEVICE_ID%!", exception);
        }
        return (T)object;
    }

    public <ListenerType> void registerCallback(String string, Class<ListenerType> clazz, ListenerType ListenerType, String string2, String string3) throws DeviceControllerException {
        try {
            this.devObjServerConnection.registerCallback(string, clazz, ListenerType, string2, string3);
        }
        catch (Exception exception) {
            throw new DeviceControllerException(this.deviceId, "Failed to register \"" + string + "\" listener" + " of device %DEVICE_ID%!", exception);
        }
    }

    public void unregisterCallback(String string, Object object) {
        try {
            this.devObjServerConnection.unregisterCallback(string, object);
        }
        catch (Exception exception) {
            LOGGER.debug((Object)("Exception while unregistering \"" + string + "\" listener of device " + this.deviceId + "!"), (Throwable)exception);
        }
    }

    public void openFailed() {
    }

    public void connectionLost() {
        this.notifyDeviceDisconnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyDeviceDisconnected() {
        DeviceControllerListener[] deviceControllerListenerArray = null;
        DeviceControllerListener[] deviceControllerListenerArray2 = this;
        synchronized (this) {
            if (!this.deviceDisconnected) {
                deviceControllerListenerArray = this.getCurrentListeners();
                this.deviceDisconnected = true;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (deviceControllerListenerArray != null) {
                for (DeviceControllerListener deviceControllerListener : deviceControllerListenerArray) {
                    deviceControllerListener.deviceDisconnected((DeviceController)this);
                }
            }
            this.stop();
            return;
        }
    }

    private void showDeviceOutput(DeviceOutput deviceOutput, String string) {
        if (deviceOutput == null) {
            System.err.println("No " + string + " output for device " + this.deviceId + "!");
            return;
        }
        try {
            deviceOutput.connect();
            LOGGER.debug((Object)("Showing " + string + " output of device " + this.deviceId));
        }
        catch (IOException iOException) {
            String string2 = "Failed to connect to " + string + " output of device " + this.deviceId + "!";
            System.err.println(string2);
            if (iOException.getMessage() != null) {
                System.err.println("Reason:\n" + iOException.getMessage());
            }
            LOGGER.error((Object)string2, (Throwable)iOException);
        }
    }

    private void hideDeviceOutput(DeviceOutput deviceOutput, String string) {
        if (deviceOutput != null) {
            deviceOutput.disconnect();
            LOGGER.debug((Object)("Output " + string + " of device " + this.deviceId + " hidden"));
        }
    }

    private DeviceControllerListener[] getCurrentListeners() {
        DeviceControllerListener[] deviceControllerListenerArray = new DeviceControllerListener[this.listeners.size()];
        return this.listeners.toArray(deviceControllerListenerArray);
    }

    private static DeviceOutput constructDeviceOutput(int n, PrintStream printStream) {
        return n == -1 ? null : new DeviceOutput(n, printStream);
    }
}

