/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jme.toolkit.ueiproxy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;

final class DeviceOutput
implements Runnable {
    private final int port;
    private final PrintStream outputStream;
    private Socket deviceOutputSocket;
    private BufferedReader deviceOutputReader;
    private boolean outputConnected;
    private Thread thread;

    public DeviceOutput(int n, PrintStream printStream) {
        this.port = n;
        this.outputStream = printStream;
    }

    public void connect() throws IOException {
        this.deviceOutputSocket = new Socket(InetAddress.getLocalHost(), this.port);
        try {
            this.deviceOutputReader = new BufferedReader(new InputStreamReader(this.deviceOutputSocket.getInputStream()));
            this.outputConnected = true;
            this.thread = new Thread(this);
            this.thread.start();
        }
        catch (IOException iOException) {
            this.deviceOutputSocket.close();
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        DeviceOutput deviceOutput = this;
        synchronized (deviceOutput) {
            this.closeOutput();
        }
        if (this.thread != null) {
            try {
                this.thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.thread = null;
        }
        this.deviceOutputReader = null;
        this.deviceOutputSocket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        try {
            object = this.deviceOutputReader.readLine();
            while (object != null) {
                this.outputStream.println((String)object);
                object = this.deviceOutputReader.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        object = this;
        synchronized (object) {
            this.closeOutput();
        }
    }

    private void closeOutput() {
        if (this.outputConnected) {
            try {
                this.deviceOutputSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.deviceOutputReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.outputConnected = false;
        }
    }
}

