/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp.io.j2se.wma.client;

import com.sun.jme.toolkit.jsr120.shared.WmaServerInterface;
import com.sun.jme.toolkit.jsr120.shared.WmaServerListener;
import com.sun.jme.toolkit.remoting.client.api.ObjectServerConnection;
import com.sun.kvem.midp.io.j2se.wma.client.WmaClient;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Set;
import org.apache.log4j.Logger;

public class WMAClientBridge {
    private static final String WMASERVER_ID = "WmaServer";
    private ObjectServerConnection deviceManagerConnection;
    private String phoneNumber;
    private boolean allocatedRequestedPhoneNumber;
    private String requestedPhoneNumber;
    private transient WmaServerInterface server;
    private static WMAClientBridge INSTANCE;
    public static final Logger LOGGER;
    private static int serverPort;
    private int trafficPort;

    public void setDeviceManagerConnection(ObjectServerConnection objectServerConnection) {
        this.deviceManagerConnection = objectServerConnection;
    }

    public static void setServerPort(int n) {
        serverPort = n;
    }

    public WMAClientBridge() {
        INSTANCE = this;
    }

    public synchronized String getPhoneNumber() {
        return this.phoneNumber;
    }

    public String getRequestedPhoneNumber() {
        return this.requestedPhoneNumber;
    }

    public boolean isAllocatedRequestedPhoneNumber() {
        return this.allocatedRequestedPhoneNumber;
    }

    public synchronized String[] getPossibleDestinationNumbers() {
        Set set = this.server.getPhoneNumbers();
        set.remove(this.phoneNumber);
        return set.toArray(new String[set.size()]);
    }

    public synchronized void setPhoneNumber(String string) {
        this.phoneNumber = string;
    }

    public synchronized boolean changePhoneNumber(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        if (string.equals(this.phoneNumber)) {
            return true;
        }
        LOGGER.debug((Object)"Asking to allocate new phone number...");
        String string2 = this.server.allocatePhoneNumber(string);
        if (!string2.equals(string)) {
            LOGGER.debug((Object)"Number was not allocated.");
            this.server.freePhoneNumber(string2);
            return false;
        }
        LOGGER.debug((Object)"New number allocated successfully, deallocating the old number.");
        this.server.freePhoneNumber(this.phoneNumber);
        this.phoneNumber = string2;
        this.server.setClientPort(this.phoneNumber, WMAClientBridge.INSTANCE.trafficPort);
        this.server.setClientType(this.phoneNumber, 3);
        return true;
    }

    public void start() throws Exception {
        String string;
        this.server = (WmaServerInterface)this.deviceManagerConnection.findObject(WmaServerInterface.class, WMASERVER_ID);
        this.allocatedRequestedPhoneNumber = false;
        LOGGER.debug((Object)"Asking to allocate phone number...");
        if (this.phoneNumber != null && !this.phoneNumber.equals("") && !this.phoneNumber.equals("sequential")) {
            this.requestedPhoneNumber = this.phoneNumber;
            string = this.server.allocatePhoneNumber(this.phoneNumber);
        } else {
            string = this.server.allocatePhoneNumber();
            this.allocatedRequestedPhoneNumber = true;
        }
        LOGGER.debug((Object)("Got phone number " + string));
        if (string.equals(this.phoneNumber)) {
            this.allocatedRequestedPhoneNumber = true;
        }
        this.phoneNumber = string;
        WMAClientBridge.INSTANCE.trafficPort = WMAClientBridge.freePortNumber();
        LOGGER.debug((Object)("Found free port for WMA traffic: " + WMAClientBridge.INSTANCE.trafficPort));
        this.server.setClientPort(this.phoneNumber, WMAClientBridge.INSTANCE.trafficPort);
        this.server.setClientType(this.phoneNumber, 3);
    }

    public void stop() throws Exception {
        this.server.freePhoneNumber(this.phoneNumber);
        this.server = null;
    }

    public static byte[] initializeWMASupport() {
        try {
            WmaClient wmaClient = new WmaClient();
            wmaClient.init(null, 3);
            wmaClient.setClientTrafficPort(WMAClientBridge.INSTANCE.trafficPort);
            String string = String.valueOf(WMAClientBridge.INSTANCE.trafficPort) + '\n' + serverPort + '\n' + WMAClientBridge.INSTANCE.phoneNumber;
            LOGGER.debug((Object)("initializeWMASupport returns: [" + string + "]"));
            return string.getBytes();
        }
        catch (Exception exception) {
            return new byte[0];
        }
    }

    private static int freePortNumber() throws SocketException {
        DatagramSocket datagramSocket = new DatagramSocket();
        int n = datagramSocket.getLocalPort();
        datagramSocket.close();
        return n;
    }

    public void addWmaServerListener(WmaServerListener wmaServerListener) {
        try {
            this.deviceManagerConnection.registerCallback(WMASERVER_ID, WmaServerListener.class, (Object)wmaServerListener, "addWmaServerListener", "removeWmaServerListener");
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Cannot add listener to WMA Server", (Throwable)exception);
        }
    }

    public void removeWmaServerListener(WmaServerListener wmaServerListener) {
        try {
            this.deviceManagerConnection.unregisterCallback(WMASERVER_ID, (Object)wmaServerListener);
        }
        catch (Exception exception) {
            LOGGER.error((Object)"Cannot remove listener from WMA Server", (Throwable)exception);
        }
    }

    public static void cleanupWMASupport() {
    }

    static {
        LOGGER = Logger.getLogger(WMAClientBridge.class);
    }
}

