/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp.io.j2se.wma.client;

import com.sun.kvem.midp.io.j2se.wma.common.DatagramRecord;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class WmaClient {
    private static final int BUFFER_SIZE = 1500;
    public static final Logger LOGGER = Logger.getLogger(WmaClient.class);
    private DatagramSocket trafficSocket;
    private int clientTrafficPort;
    private List queue;
    private MessageListener listener;
    private Thread receiver;

    public void setClientTrafficPort(int n) {
        this.clientTrafficPort = n;
    }

    protected void init(String string, int n) {
        this.clientTrafficPort = 0;
        this.trafficSocket = null;
        this.listener = null;
    }

    public void connect() throws IOException {
        if (this.listener != null) {
            this.setupReceiver();
        }
    }

    synchronized void setupReceiver() {
        if (this.receiver == null) {
            this.receiver = new Thread(new DatagramReader());
            this.receiver.start();
        }
    }

    public void setMessageListener(MessageListener messageListener) {
        this.listener = messageListener;
    }

    synchronized void setupTrafficSocket() {
        if (this.trafficSocket == null) {
            LOGGER.debug((Object)("Opening Datagram traffic socket on port: " + this.clientTrafficPort));
            try {
                this.trafficSocket = new DatagramSocket(this.clientTrafficPort);
            }
            catch (IOException iOException) {
                LOGGER.error((Object)iOException, (Throwable)iOException);
                throw new RuntimeException("Could not open datagram connection on port " + this.clientTrafficPort);
            }
        }
    }

    private class DatagramReader
    implements Runnable {
        DatagramReader() {
            WmaClient.this.queue = new Vector(256);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOGGER.info((Object)("Listening for traffic on port " + WmaClient.this.clientTrafficPort));
            while (WmaClient.this.trafficSocket != null) {
                try {
                    byte[] byArray = new byte[1500];
                    DatagramPacket datagramPacket = new DatagramPacket(byArray, byArray.length);
                    try {
                        WmaClient.this.trafficSocket.receive(datagramPacket);
                    }
                    catch (SocketException socketException) {
                        return;
                    }
                    List list = WmaClient.this.queue;
                    synchronized (list) {
                        WmaClient.this.queue.add(datagramPacket);
                        WmaClient.this.queue.notify();
                    }
                    if (WmaClient.this.listener == null) continue;
                    list = new DatagramRecord();
                    list.parseData(datagramPacket.getData(), datagramPacket.getLength());
                    if (!list.getHeader("Segments").equals("1") && !list.getHeader("Fragment").equals("0")) continue;
                    new Thread(new Runnable(){

                        @Override
                        public void run() {
                            WmaClient.this.listener.notifyIncomingMessage(WmaClient.this);
                        }
                    }).start();
                }
                catch (InterruptedIOException interruptedIOException) {
                    break;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            LOGGER.info((Object)("Done listening on traffic port (but it's still open!): " + WmaClient.this.clientTrafficPort));
        }
    }

    public static interface MessageListener {
        public void notifyIncomingMessage(WmaClient var1);
    }
}

